@extends('front.layout')
@section('title')
 {{__('message.Home')}}
@stop
@section('meta-data')
<?php $res_curr = explode("-",$setting->currency);?>
<meta property="og:type" content="website"/>
<meta property="og:url" content="{{route('home')}}"/>
<meta property="og:title" content="{{__('message.site_name')}}"/>
<meta property="og:image" content="{{asset('public/img/').'/'.$setting->logo}}"/>
<meta property="og:image:width" content="250px"/>
<meta property="og:image:height" content="250px"/>
<meta property="og:site_name" content="{{__('message.site_name')}}"/>
<meta property="og:description" content="{{__('message.meta_description')}}"/>
<meta property="og:keyword" content="{{__('message.meta_keyword')}}"/>
<link rel="shortcut icon" href="{{asset('public/img/').'/'.$setting->favicon}}">
<meta name="viewport" content="width=device-width, initial-scale=1">
@stop
@section('content')
<section class="banner-section style-five">
            <?php 
              $main_banner = asset('public/img').'/'.$setting->main_banner;
              $search_banner = asset('public/img').'/'.$setting->search_banner;
            ?>
            <div class="map-layer" style="background-image: url('{{$main_banner}}');"></div>
            <div class="auto-container">
               <div class="content-inner" style="z-index: auto; text-align: center;">
                   <h1 style="color:#f6f6f6 !important; font-size: -webkit-xxx-large; letter-spacing: 1px; font-weight: 300;"><span style="color:#f6f6f6 !important; font-weight:700; font-size: xxx-large; ">LABORATORY</span> diagnosis</h1><br>
                   <p style="color:#f6f6f6 !important; font-size: large; letter-spacing: 1px; font-weight: 400;">As a leading pathology practice, we specialize in the accurate and timely analysis of tissue samples, blood, and other specimens, providing crucial insights for accurate diagnoses and effective treatment plans.</p>
               </div>
               <div class="content-box">
                  <figure class="image-box"><img src="{{$search_banner}}" alt=""></figure>
                  <h2>{{__('message.Find Package/Test')}}</h2>
                  <div class="form-inner">
                     <form action="{{route('search-item')}}" method="post">
                        {{csrf_field()}}
                        <div class="form-group clearfix">

                           <input type="text" name="tags" id="tags" placeholder="{{__('message.Search Packages,Parameters')}}" required="">
                           <button type="submit"><i class="icon-Arrow-Right"></i></button>
                        </div>
                     </form>
                  </div>
               </div>
            </div>
         </section>
         <section class="process-style-two alternat-2 centred">
            <div class="pattern-layer">
               <?php 
                  $path1 = asset('public/front/Docpro/assets/images/shape/shape-39.png');
                  $path2 = asset('public/front/Docpro/assets/images/shape/shape-42.png');
                  $arrow1 = asset('public/front/Docpro/assets/images/icons/arrow-1.png');
                  $sharp45 = asset('public/front/Docpro/assets/images/shape/shape-45.png');
                  $sharp46 = asset('public/front/Docpro/assets/images/shape/shape-46.png');
                  ?>
               <div class="pattern-1" style="background-image: url('{{$path1}}');"></div>
               <div class="pattern-4" style="background-image: url('{{$path2}}');"></div>
            </div>
            <div class="auto-container">
               <div class="sec-title centred">
                  <p></p>
                  <h2>{{__('message.Browse by Category')}}</h2>
               </div>
               <div class="inner-content">
                  <div class="row clearfix">
                     <div class="brand-carousel section-padding owl-carousel">
                        @foreach($category as $c)
                        <div class="single-logo">
                           <div class="col-lg-12 col-md-6 col-sm-12 category-block">
                              <div class="category-block-one wow fadeInUp animated animated" data-wow-delay="00ms" data-wow-duration="1500ms">
                                 <div class="inner-box">
                                    <div class="pattern">
                                       <div class="pattern-1" style="background-image: url('{{$sharp45}}');"></div>
                                       <div class="pattern-2" style="background-image: url('{{$sharp46}}');"></div>
                                    </div>
                                    <figure class="icon-box"><img src="{{asset('storage/app/public/Subcategory').'/'.$c->image}}" alt=""></figure>
                                    <h3><a href="{{ route('subcategory-detail', ['id' => $c->id]) }}">{{$c->name}}</a></h3>
                                    <span>{{$c->short_desc}}</span>
                                    <div class="link"><a href="{{ route('category-list', ['id' => $c->id]) }}"><i class="icon-Arrow-Right"></i></a></div>
                                    <div class="btn-box"><a href="{{ route('subcategory-detail', ['id' => $c->id]) }}" class="theme-btn-one">{{__('message.View List')}}<i class="icon-Arrow-Right"></i></a></div>
                                 </div>
                              </div>
                           </div>
                        </div>
                        @endforeach
                     </div>
                  </div>
               </div>
            </div>
         </section>
         <section class="pricing-section bg-color-3 sec-pad">
            <div class="auto-container">
               <div class="sec-title centred">
                  <p></p>
                  <h2>{{__('message.Our Popular Packages')}}</h2>
               </div>
               <div class="tabs-box">
                  <?php 
                     $sharp75 = asset('public/front/Docpro/assets/images/shape/shape-75.png');
                     $sharp76 = asset('public/front/Docpro/assets/images/shape/shape-76.png');
                     $sharp77 = asset('public/front/Docpro/assets/images/shape/shape-77.png');
                     $sharp68 = asset('public/front/Docpro/assets/images/shape/shape-68.png');
                     $sharp69 = asset('public/front/Docpro/assets/images/shape/shape-69.png');
                     ?>
                  <div class="tabs-content">
                     <div class="tab active-tab" id="tab-1">
                        <div class="row clearfix">
                           @foreach($data_popular as $pl)
                             <?php $discount = 100 * ($pl->mrp - $pl->price) / $pl->mrp; ?>
                           <div class="col-lg-4 col-md-6 col-sm-12 pricing-block">
                           <div class="pricing-block-one">
                              <div class="pricing-table">

                                 <div class="pattern">
                                     <span class="discount" >{{round($discount)}} %</span>
                                    <div class="pattern-1" style="background-image: url('{{$sharp75}}');"></div>
                                    <div class="pattern-2" style="background-image: url('{{$sharp76}}');"></div>
                                    <div class="pattern-3" style="background-image: url('{{$sharp77}}');"></div>
                                 </div>
                                 <div class="table-header">
                                    <h2>{{$pl->name}}</h2>
                                        
                                    <h3><span style="text-decoration: line-through;">${{$pl->mrp}}</span> / ${{$pl->price}} </h3>
                                    <p><span>{{__('message.Includes')}} :  </span> {{$pl->no_of_parameter}} {{__('message.Parameters')}} </p>
                                 </div>
                                 <div class="table-content">
                                    <ul class="list clearfix" style="height: 150px;">
                                       <?php $arr = explode("#",$pl->paramater_data);?>
                                       @foreach($arr as $a)
                                         <li>{{$a}}</li>
                                       @endforeach
                                    </ul>
                                 </div>
                                 <div class="table-footer">
                                    @if($pl->type==1)
                                    <div class="link"><a href="{{ route('package-detail', ['id' => $pl->type_id ]) }}"><i class="icon-Arrow-Right"></i></a></div>
                                    <div class="btn-box"><a href="{{ route('package-detail', ['id' => $pl->type_id ]) }}" class="theme-btn-one">{{__('message.Know More')}}<i class="icon-Arrow-Right"></i></a></div>
                                    @endif
                                    @if($pl->type==2)
                                    <div class="link"><a href="{{ route('parameter-detail', ['id' => $pl->type_id ]) }}"><i class="icon-Arrow-Right"></i></a></div>
                                    <div class="btn-box"><a href="{{ route('parameter-detail', ['id' => $pl->type_id ]) }}" class="theme-btn-one">{{__('message.Know More')}}<i class="icon-Arrow-Right"></i></a></div>
                                    @endif
                                    @if($pl->type==3)
                                    <div class="link"><a href="{{ route('profile-detail', ['id' => $pl->type_id ]) }}"><i class="icon-Arrow-Right"></i></a></div>
                                    <div class="btn-box"><a href="{{ route('profile-detail', ['id' => $pl->type_id ]) }}" class="theme-btn-one">{{__('message.Know More')}}<i class="icon-Arrow-Right"></i></a></div>
                                    @endif
                                    
                                 </div>
                              </div>
                           </div>
                        </div>
                           @endforeach
                        </div>
                        @if(count($popular_package)>6)
                                    <div class="btn-box row" style="margin-top: 30px;    display: flex;justify-content: center;"><a href="{{route('show-package-list')}}" class="theme-btn-one">{{__('message.More Package')}}<i class="icon-Arrow-Right"></i></a></div>
                                    @endif
                     </div>
                  
                  </div>
               </div>
            </div>
         </section>
         <section class="funfact-section bg-color-2 centred">
            <div class="pattern-layer">
               <div class="pattern-1" style="background-image: url('{{$sharp68}}');"></div>
               <div class="pattern-2" style="background-image: url('{{$sharp69}}');"></div>
            </div>
            <div class="auto-container">
               <div class="row clearfix">
                  <div class="col-lg-3 col-md-6 col-sm-12 counter-block">
                     <div class="counter-block-one wow slideInUp animated animated animated" data-wow-delay="00ms" data-wow-duration="1500ms">
                        <div class="inner-box">
                           <div class="count-outer count-box">
                              <span class="count-text" data-speed="1500" data-stop="{{$setting->largest_phlebotomist}}">0</span>
                           </div>
                           <h4>{{__('message.Largest Phlebotomist')}}</h4>
                        </div>
                     </div>
                  </div>
                  <div class="col-lg-3 col-md-6 col-sm-12 counter-block">
                     <div class="counter-block-one wow slideInUp animated animated animated" data-wow-delay="200ms" data-wow-duration="1500ms">
                        <div class="inner-box">
                           <div class="count-outer count-box">
                              <span class="count-text" data-speed="1500" data-stop="{{$setting->satisfied_customers}}">0</span>
                           </div>
                           <h4>{{__('message.Satisfied Customers')}}</h4>
                        </div>
                     </div>
                  </div>
                  <div class="col-lg-3 col-md-6 col-sm-12 counter-block">
                     <div class="counter-block-one wow slideInUp animated animated animated" data-wow-delay="400ms" data-wow-duration="1500ms">
                        <div class="inner-box">
                           <div class="count-outer count-box">
                              <span class="count-text" data-speed="1500" data-stop="{{$setting->total_test}}">0</span>
                           </div>
                           <h4>{{__('message.Total Tests')}}</h4>
                        </div>
                     </div>
                  </div>
                  <div class="col-lg-3 col-md-6 col-sm-12 counter-block">
                     <div class="counter-block-one wow slideInUp animated animated animated" data-wow-delay="600ms" data-wow-duration="1500ms">
                        <div class="inner-box">
                           <div class="count-outer count-box">
                              <span class="count-text" data-speed="1500" data-stop="{{$setting->presence_cities}}">0</span>
                           </div>
                           <h4>{{__('message.Presence Cities')}}</h4>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </section>
        
         <section class="cta-section alternat-2 bg-color-2" id="download_app">
            <div class="pattern-layer">
               <?php 
                  $sharp17 = asset('public/front/Docpro/assets/images/shape/shape-17.png');
                  $sharp18 = asset('public/front/Docpro/assets/images/shape/shape-18.png');
                  $sharp19 = asset('public/front/Docpro/assets/images/shape/shape-19.png');
                  ?>
               <div class="pattern-1" style="background-image: url('{{$sharp17}}');"></div>
               <div class="pattern-2" style="background-image: url('{{$sharp18}}');"></div>
               <div class="pattern-3" style="background-image: url('{{$sharp19}}');"></div>
            </div>
            <div class="auto-container">
               <div class="row clearfix">
                  <div class="col-lg-6 col-md-12 col-sm-12 content-column">
                     <div class="content_block_2">
                        <div class="content-box">
                           <div class="sec-title light">
                              <p>{{__('message.Download apps')}}</p>
                              <h2>{{__('message.For Better Test Download Mobile App')}}</h2>
                           </div>
                           <div class="text">
                              <p>Lorem ipsum dolor sit amet consectur adipiscing elit sed eiusmod tempor incididunt labore dolore magna.</p>
                           </div>
                           <div class="btn-box clearfix">
                              <a href="{{$setting->appstore_url}}" class="download-btn app-store">
                                 <i class="fab fa-apple"></i>
                                 <span>{{__('message.Download on')}}</span>
                                 <h3>{{__('message.App Store')}}</h3>
                              </a>
                              <a href="{{$setting->playstore_url}}" class="download-btn play-store">
                                 <i class="fab fa-google-play"></i>
                                 <span>{{__('message.Download on')}}</span>
                                 <h3>{{__('message.Google Play')}}</h3>
                              </a>
                           </div>
                        </div>
                     </div>
                  </div>
                  <div class="col-lg-6 col-md-12 col-sm-12 image-column">
                     <div class="image-box wow fadeInUp animated animated" data-wow-delay="00ms" data-wow-duration="1500ms">
                        <figure class="image"><img src="{{asset('public/img').'/'.$setting->mobile_app_banner}}" alt=""></figure>
                     </div>
                  </div>
               </div>
            </div>
         </section>
         <section class="testimonial-style-two bg-color-3">
            <div class="pattern-layer">
               <?php 
                  $sharp55 = asset('public/front/Docpro/assets/images/shape/shape-55.png');
                  $sharp56 = asset('public/front/Docpro/assets/images/shape/shape-56.png');
                  $sharp57 = asset('public/front/Docpro/assets/images/shape/shape-57.png');
                  $sharp58 = asset('public/front/Docpro/assets/images/shape/shape-58.png');
                  $sharp59 = asset('public/front/Docpro/assets/images/shape/shape-59.png');
                  ?>
               <div class="pattern-1" style="background-image: url('{{$sharp55}}');"></div>
               <div class="pattern-2" style="background-image: url('{{$sharp56}}');"></div>
               <div class="pattern-3" style="background-image: url('{{$sharp57}}');"></div>
               <div class="pattern-4" style="background-image: url('{{$sharp58}}');"></div>
               <div class="pattern-5" style="background-image: url('{{$sharp59}}');"></div>
            </div>
            <div class="auto-container">
               <div class="sec-title centred">
                  <p></p>
                  <h2>{{__('message.Customers Review')}}</h2>
               </div>
               <div class="three-item-carousel owl-carousel owl-theme owl-nav-none">
                  @foreach($data_feedback as $df)
                  <div class="testimonial-block-two">
                     <div class="inner-box">
                        <div class="text">
                           <p> {{ \Illuminate\Support\Str::limit($df->description,55, $end='...') }} </p>
                        </div>
                        <div class="author-info">
                            @php
                                if(!empty($df->userdata->profile_pic)){
                                    $profile = $df->userdata->profile_pic;
                                    }
                                else{
                                    $profile = "16491979271101179647.png";
                                    }
                            @endphp
                           <figure class="author-thumb"><img src="{{asset('storage/app/public/profile/'.$profile)}}" alt="" style="height:60px;"></figure>
                           <h4>{{isset($df->userdata->name)?$df->userdata->name:""}}</h4>
                           <span class="designation">{{isset($df->userdata->email)?$df->userdata->email:""}}</span>
                        </div>
                     </div>
                  </div>
                @endforeach
               </div>
            </div>
         </section>
@stop
@section('footer')
<script type="text/javascript">
   <?php
         if($setting->is_rtl==1){
   ?>
         $('.brand-carousel').owlCarousel({
               loop:true,
               rtl:true,
               margin:10,
               autoplay:true,
               responsive:{
                 0:{
                   items:1
                 },
                 600:{
                   items:3
                 },
                 1000:{
                   items:4
                 }
               }
             })
         
      <?php }else{?>
         $('.brand-carousel').owlCarousel({
               loop:true,
             
               margin:10,
               autoplay:true,
               responsive:{
                 0:{
                   items:1
                 },
                 600:{
                   items:3
                 },
                 1000:{
                   items:4
                 }
               }
             })
   <?php }?>
      </script>
@stop