<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Category;
use App\Models\User;
use App\Models\Subcategory;
use DataTables;
use App\Models\Package;
use App\Models\Package_FRQ;
use App\Models\Parameter;
use App\Models\Profiles;
use App\Models\TestDetails;
use App\Models\Popular_package;
use Session;
use Auth;
use Hash;

class PackageController extends Controller
{
    
    public function show_package(){
        return view("admin.package.default");
    }

    public function package_datatable(){
         $package =Package::whereNull("deleted_at")->get();
         return DataTables::of($package)
            ->editColumn('id', function ($package) {
                return $package->id;
            })
            ->editColumn('name', function ($package) {
                return $package->name;
            })
            ->editColumn('frq', function ($package) {
                return $package->id;
            })    
            ->editColumn('action', function ($package) {  
                $edittext =__('message.Edit');
                $deletetext = __('message.Delete');
                $edit = url('save_package',array('id'=>$package->id,'tab'=>'1'));
                $delete = url('deletepackage',array('id'=>$package->id));
                           
                return '<a  href="'.$edit.'" rel="tooltip"  class="btn btn-success" data-original-title="banner" style="margin-right: 10px;color: white !important;">'.$edittext.'</a><a onclick="delete_record(' . "'" . $delete. "'" . ')" rel="tooltip"  class="btn btn-danger" data-original-title="Remove" style="margin-right: 10px;color:white !important">'.$deletetext.'</a>';              
            })           
            ->make(true);
    }

    public function show_save_package($id,$tab){
        $data = Package::find($id);
        $category = Subcategory::where("is_deleted",'0')->get();
        $get_all_package = Package::whereNull("deleted_at")->get();
        $get_all_paramter = Parameter::whereNull("deleted_at")->get();
        $get_profiles = Profiles::all();
        $test_details = TestDetails::where("package_id",$id)->get();
        return view("admin.package.save_package")->with("id",$id)->with("category",$category)->with("packages",$get_all_package)->with("data",$data)->with("get_all_paramter",$get_all_paramter)->with("tab",$tab)->with("get_profiles",$get_profiles)->with("test_details",$test_details);
    }

    public function show_package_basic_info(Request $request){
        //dd($request->all());
        if($request->get("id")==0){
            $data = new Package();
        }else{
            $data = Package::find($request->get("id"));
        }
        $data->name = $request->get("name");
        $data->short_desc = $request->get("short_desc");
        $data->description = $request->get("description");
        $data->category_id = $request->get("category");
      //  $data->subcategory_id = $request->get("subcategory_id");
        $data->mrp = $request->get("mrp");
        $data->price = $request->get("price");
        $data->save();
        // Session::flash('message',"Package Basic Information Save Successfully"); 
        Session::flash('message',__('message.Package Basic Information Save Successfully'));
        Session::flash('alert-class', 'alert-success');
        return redirect('save_package/'.$data->id.'/2');
    }

    public function show_package_lab_info(Request $request){
        //dd($request->all());
        if($request->get("id")==0){ 
          Session::flash('message',__('message.Please First Save Package Basic Information Then Proceed Ahead'));
          Session::flash('alert-class', 'alert-danger');
          return redirect()->back();
        }
        $data = Package::find($request->get("id"));
        $data->paramter_included = $request->get("paramter_included");
        $data->report_time = $request->get("report_time");
        $data->sample_collection = $request->get("sample_collection");
        $data->sample_collection_fee = $request->get("sample_collection_fee");
        $data->fasting_time = $request->get("fasting_time");
        $data->fast_time = $request->get("fast_time");
        $data->test_recommended_for = implode(",",$request->get("test_recommended_for"));
        $data->test_recommended_for_age = $request->get("test_recommended_for_age");
        if($request->get("realted_package")){
            $data->realted_package = implode(",",$request->get("realted_package"));
        }
        
        if($request->hasfile("lab_report")){
                $old_report = $data->lab_report;
                $file = $request->file('lab_report');
                $filename = $file->getClientOriginalName();
                $extension = $file->getClientOriginalExtension() ?: 'png';               
                $picture = rand().time() . '.' . $extension;
                $destinationPath = Storage_path("app/public/sample_report");
                $request->file('lab_report')->move($destinationPath, $picture);
                $data->lab_report =$picture;
                if($old_report!=""){
                    $this->removeImage("sample_report"."/".$old_report);
                }
                
        }
        $data->save();
        Session::flash('message',__('message.Package Lab Information Save Successfully')); 
        Session::flash('alert-class', 'alert-success');
        return redirect('save_package/'.$data->id.'/3');
    }

    public function show_save_package_test_info(Request $request){
        //dd($request->all());
        if($request->get("id")==0){
          // Session::flash('message',"Please First Save Package Basic Information Then Proceed Ahead");
          Session::flash('message',__('message.Please First Save Package Basic Information Then Proceed Ahead')); 
          Session::flash('alert-class', 'alert-danger');
          return redirect()->back();
        }
        TestDetails::where("package_id",$request->get("id"))->delete();
        $arr = $request->get("testdetail");
        foreach($arr as $a){
            $store = new TestDetails();
            $store->type = $a['type'];
            $store->type_id = $a['type_id'];
            $store->package_id = $request->get("id");
            $store->save();
        }
        // Session::flash('message',"Package Test Information Save Successfully");
        Session::flash('message',__('message.Package Test Information Save Successfully')); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('show-package');
    }

    public function show_save_parameter($id,$tab){
        $data = Parameter::find($id);
        $category = Subcategory::where('is_deleted','0')->get();
        return view("admin.parameter.save_parameter")->with("id",$id)->with("data",$data)->with("tab",$tab)->with("category",$category);
    }

    public function getlistofparameter(){
        $data = Parameter::whereNull('deleted_at')->get();
        return $data;
    }

    public function show_getsubcategorybycategory($id)
    {
        $data = Subcategory::where("category_id",$id)->where('is_deleted','0')->get();
        $txt = "";
        foreach ($data as $k) {
            $txt = $txt.'<option value="'.$k->id.'">'.$k->name.'</option>';
        }
        return $txt;
    }

    public function show_save_parameter_basic_info(Request $request){
        if($request->get("id")==0){
            $data = new Parameter();
        }else{
            $data = Parameter::find($request->get("id"));
        }
        $data->name = $request->get("name");
        $data->short_desc = $request->get("short_desc");
        $data->description = $request->get("description");
        $data->mrp = $request->get("mrp");
        $data->price = $request->get("price");
        $data->category_id = $request->get("category_id");
        $data->save();
        // Session::flash('message',"Parameter Basic Information Save Successfully");
        Session::flash('message',__('message.Parameter Basic Information Save Successfully')); 
        Session::flash('alert-class', 'alert-success');
        return redirect('save_parameter/'.$data->id.'/2');
    }

    public function show_save_parameter_lab_info(Request $request){
        $data = Parameter::find($request->get("id"));
        $data->report_time = $request->get("report_time");
        $data->sample_collection = $request->get("sample_collection");
        $data->sample_collection_fee = $request->get("sample_collection_fee");
        $data->fasting_time = $request->get("fasting_time");
        $data->fast_time = $request->get("fast_time");
        $data->test_recommended_for = implode(",",$request->get("test_recommended_for"));
        $data->test_recommended_for_age = $request->get("test_recommended_for_age");
        if($request->hasfile("lab_report")){
                $old_report = $data->lab_report;
                $file = $request->file('lab_report');
                $filename = $file->getClientOriginalName();
                $extension = $file->getClientOriginalExtension() ?: 'png';               
                $picture = rand().time() . '.' . $extension;
                $destinationPath = Storage_path("app/public/sample_report");
                $request->file('lab_report')->move($destinationPath, $picture);
                $data->lab_report =$picture;
                if($old_report!=""){
                    $this->removeImage("sample_report"."/".$old_report);
                }
                
        }
        $data->save();

        // Session::flash('message',"Parameter Lab Information Save Successfully");
        Session::flash('message',__('message.Parameter Lab Information Save Successfully')); 
        Session::flash('alert-class', 'alert-success');
        return redirect('save_parameter/'.$data->id.'/2');
    }

    public function show_parameter(){
        return view("admin.parameter.default");
    }

    public function parameter_datatable(){
        $parameter =Parameter::whereNull("deleted_at")->get();
         return DataTables::of($parameter)
            ->editColumn('id', function ($parameter) {
                return $parameter->id;
            })
            ->editColumn('name', function ($parameter) {
                return $parameter->name;
            }) 
             ->editColumn('short_desc', function ($parameter) {
                 if(strlen($parameter->short_desc)>30){
                     return substr(strip_tags($parameter->short_desc),0,30) . "..."; 
                 }else{
                     return $parameter->short_desc;
                 }
                
            })
            ->editColumn('price', function ($parameter) {
                return $parameter->price;
            })
            ->editColumn('frq', function ($parameter) {
                return $parameter->id;
            })    
            ->editColumn('action', function ($parameter) { 
                $edittext =__('message.Edit');
                $deletetext = __('message.Delete'); 
                $edit = url('save_parameter',array('id'=>$parameter->id,'tab'=>'1'));
                $delete = url('delete_parameter',array('id'=>$parameter->id));
                           
                return '<a  href="'.$edit.'" rel="tooltip"  class="btn btn-success" data-original-title="banner" style="margin-right: 10px;color: white !important;">'.$edittext.'</a><a onclick="delete_record(' . "'" . $delete. "'" . ')" rel="tooltip"  class="btn btn-danger" data-original-title="Remove" style="margin-right: 10px;color:white !important">'.$deletetext.'</a>';              
            })           
            ->make(true);
    }

    public function show_delete_parameter($id){
        $store = Parameter::find($id);
        if($store){
                $store->delete();
                // Session::flash('message',"Parameter Delete Successfully");
                Session::flash('message',__('message.Parameter Delete Successfully')); 
                Session::flash('alert-class', 'alert-success');
                return redirect()->back();
        }else{
                // Session::flash('message',"Parameter Not Found");
                Session::flash('message',__('message.Parameter Not Found')); 
                Session::flash('alert-class', 'alert-danger');
                return redirect()->back();
        }
    }


    public function viewfrq($id,$type){
        return view("admin.frq.default")->with("id",$id)->with("type",$type);
    }

    public function frq_datatable($id,$type){
        $frq =Package_FRQ::whereNull("deleted_at")->where("package_id",$id)->where("type",$type)->get();
         return DataTables::of($frq)
            ->editColumn('id', function ($frq) {
                return $frq->id;
            })
            ->editColumn('question', function ($frq) {
                return $frq->question;
            })
            ->editColumn('ans', function ($frq) {
                return substr($frq->ans,0,100).'...';
            }) 


            ->editColumn('action', function ($frq) { 
                $edittext =__('message.Edit');
                $deletetext = __('message.Delete'); 
                $delete = url('delete_frq',array('id'=>$frq->id));
                 return '<a  onclick="edit_frq('.$frq->id.')" rel="tooltip"  data-bs-toggle="modal" data-bs-target="#editfrq" class="btn btn-success" data-original-title="banner" style="margin-right: 10px;color: white !important;">'.$edittext.'</a><a onclick="delete_record(' . "'" . $delete. "'" . ')" rel="tooltip"  class="btn btn-danger" data-original-title="Remove" style="margin-right: 10px;color:white !important">'.$deletetext.'</a>';              
            })           
            ->make(true);
    }

    public function update_frq(Request $request){
        if($request->get("id")==0){
            $store = new Package_FRQ(); 
            // $msg = "FRQ Add Successfully";
            $msg = __('message.FRQ Add Successfully');
        }else{
            $store = Package_FRQ::find($request->get("id"));
            // $msg = "FRQ Update Successfully";
            $msg = __('message.FRQ Update Successfully'); 
        }
        $store->question = $request->get("question");
        $store->ans = $request->get("answer");
        $store->type = $request->get("type");
        $store->package_id = $request->get("package_id");
        $store->save();
        Session::flash('message',$msg); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->back();
    }

    public function show_delete_frq(Request $request){
        $store = Package_FRQ::find($id);
        if($store){
                $store->delete();
                // Session::flash('message',"FRQ Delete Successfully");
                Session::flash('message',__('message.FRQ Delete Successfully')); 
                Session::flash('alert-class', 'alert-success');
                return redirect()->back();
        }else{
                // Session::flash('message',"FRQ Not Found");
                Session::flash('message',__('message.FRQ Not Found')); 
                Session::flash('alert-class', 'alert-danger');
                return redirect()->back();
        }
    }

    public function show_getfrq($id){
        $data = Package_FRQ::find($id);
        return json_encode($data);
    }

    public function show_profiles(){
        return view("admin.profile.default");
    }

    public function show_update_profile(Request $request){
       // dd($request->all());
        if($request->get("id")==0){
           $data = new Profiles();
           $msg = __('message.Profile Add Successfully');
        }else{
           $data = Profiles::find($request->get("id"));
           $msg = __('message.Profile Update Successfully');
        }
        $data->profile_name = $request->get("name");
        $data->no_of_parameter = implode(",",$request->get("no_of_parameter"));
        $data->report_time = $request->get("report_time");
        $data->sample_collection = $request->get("sample_collection");
        $data->sample_collection_fee = $request->get("sample_collection_fee");
        $data->fasting_time = $request->get("fasting_time");
        $data->fast_time = $request->get("fast_time");
        $data->test_recommended_for = implode(",",$request->get("test_recommended_for"));
        $data->test_recommended_for_age = $request->get("test_recommended_for_age");
        $data->short_desc = $request->get("short_desc");
        $data->description = $request->get("description");
        $data->category_id = $request->get("category");
        $data->mrp = $request->get("mrp");
        $data->price = $request->get("price");
        if($request->hasfile("lab_report")){
                $old_report = $data->lab_report;
                $file = $request->file('lab_report');
                $filename = $file->getClientOriginalName();
                $extension = $file->getClientOriginalExtension() ?: 'png';               
                $picture = rand().time() . '.' . $extension;
                $destinationPath = Storage_path("app/public/sample_report");
                $request->file('lab_report')->move($destinationPath, $picture);
                $data->lab_report =$picture;
                if($old_report!=""){
                    $this->removeImage("sample_report"."/".$old_report);
                }
                
        }
        $data->save();
        Session::flash('message',$msg); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('profiles');

    }

    public function show_save_profile($id){
        $data = Profiles::find($id);
        $get_parameter = Parameter::whereNull("deleted_at")->get();
        $category = Subcategory::where("is_deleted",'0')->get();
        return view("admin.profile.save")->with("data",$data)->with("get_parameter",$get_parameter)->with("id",$id)->with("category",$category);
    }

    public function profiledatatable(){
         $pro = Profiles::all();
         return DataTables::of($pro)
            ->editColumn('id', function ($pro) {
                return $pro->id;
            })
            ->editColumn('profile_name', function ($pro) {
                return $pro->profile_name;
            })
            ->editColumn('no_of_parameter', function ($pro) {
                $arr = explode(",", $pro->no_of_parameter);
                return count($arr);
            })
            
             ->editColumn('frq', function ($parameter) {
                return $parameter->id;
            })
             ->editColumn('lab_report', function ($parameter) {
                return $parameter->lab_report;
            }) 
             
            ->editColumn('action', function ($pro) {  
                $edittext =__('message.Edit');
                $deletetext = __('message.Delete');
                $edit = url('save_profile',array('id'=>$pro->id));
                $delete = url('delete_profile',array('id'=>$pro->id));
                           
                return '<a  href="'.$edit.'" rel="tooltip"  class="btn btn-success" data-original-title="banner" style="margin-right: 10px;color: white !important;">'.$edittext.'</a><a onclick="delete_record(' . "'" . $delete. "'" . ')" rel="tooltip"  class="btn btn-danger" data-original-title="Remove" style="margin-right: 10px;color:white !important">'.$deletetext.'</a>';               
            })           
            ->make(true);
    }

    public function show_get_test_ids($type){
        $txt = "<option value=''>Select Test</option>";
        if($type==1){ // parameters
            $data = Parameter::whereNull('deleted_at')->get();
            foreach($data as $d){
                $txt = $txt.'<option value="'.$d->id.'">'.$d->name.'</option>';
            }
        }else{ // profile
            $data = Profiles::all();
             foreach($data as $d){
                $txt = $txt.'<option value="'.$d->id.'">'.$d->profile_name.'</option>';
            }
        }

        return $txt;
    }

    public function show_popular_package(){
        return view("admin.popular.default");
    }

    public function show_save_popular_package($id){
        $data = Popular_package::find($id);
        if($data){
                if($data->type=='1'){ // package
                    $data->typedata = Package::whereNull('deleted_at')->get();
                }else if($data->type=='2'){ // parmeter
                    $data->typedata = Parameter::whereNull('deleted_at')->get();
                }else{ // profile
                    $data->typedata = Profiles::whereNull('deleted_at')->get();
                }
                return view("admin.popular.save")->with("data",$data)->with("id",$id);
        }
        if($id==0){
               return view("admin.popular.save")->with("data",$data)->with("id",$id);
        }else{
                // Session::flash('message',"Something Wrong");
                Session::flash('message',__('message.Something Wrong')); 
                Session::flash('alert-class', 'alert-danger');
                return redirect()->back();
        }
    }

    public function show_searchpopulartype($id){
            $txt = "";
            if($id=='1'){ // package
                $data = Package::whereNull('deleted_at')->get();
                foreach($data as $d){
                    $txt = $txt.'<option value ='.$d->id.'>'.$d->name.'</option>';
                }
            }else if($id=='2'){ // parmeter
                $data = Parameter::whereNull('deleted_at')->get();
                foreach($data as $d){
                    $txt = $txt.'<option value ='.$d->id.'>'.$d->name.'</option>';
                }
            }else{ // profile
                $data = Profiles::whereNull('deleted_at')->get();
                foreach($data as $d){
                    $txt = $txt.'<option value ='.$d->id.'>'.$d->profile_name.'</option>';
                }
            }
            return $txt;
    }

    public function show_popularPackageTable(){
         $pro = Popular_package::all();
         return DataTables::of($pro)
            ->editColumn('id', function ($pro) {
                return $pro->id;
            })
            ->editColumn('name', function ($pro) {
                return $pro->name;
            })
            ->editColumn('action', function ($pro) {
                $edittext =__('message.Edit');
                $deletetext = __('message.Delete');  
                $edit = url('save_popular_package',array('id'=>$pro->id));
                $delete = url('delete_package',array('id'=>$pro->id));
                           
                return '<a  href="'.$edit.'" rel="tooltip"  class="btn btn-success" data-original-title="banner" style="margin-right: 10px;color: white !important;">'.$edittext.'</a><a onclick="delete_record(' . "'" . $delete. "'" . ')" rel="tooltip"  class="btn btn-danger" data-original-title="Remove" style="margin-right: 10px;color:white !important">'.$deletetext.'</a>';               
            })           
            ->make(true);
    }

    public function delete_package($id){
       $pro = Popular_package::find($id);
       if($pro){
            $pro->delete();
            $msg = "delete successful";
            Session::flash('message',$msg); 
            Session::flash('alert-class', 'alert-success');
       }else{
           $msg = "something wrong";
            Session::flash('message',$msg); 
            Session::flash('alert-class', 'alert-danger');
       }
       return redirect()->back();
    }
    
    public function delete_profile($id){
       $pro = Profiles::find($id);
       if($pro){
            $pro->delete();
            $msg = "delete successful";
            Session::flash('message',$msg); 
            Session::flash('alert-class', 'alert-success');
       }else{
           $msg = "something wrong";
            Session::flash('message',$msg); 
            Session::flash('alert-class', 'alert-danger');
       }
       return redirect()->back();
    }
    
    public function deletepackage($id){
       $pro = Package::find($id);
       if($pro){
            $pro->delete();
            $msg = "delete successful";
            Session::flash('message',$msg); 
            Session::flash('alert-class', 'alert-success');
       }else{
           $msg = "something wrong";
            Session::flash('message',$msg); 
            Session::flash('alert-class', 'alert-danger');
       }
       return redirect()->back();
    }


    public function show_update_popular_package(Request $request){
       // dd($request->all());
        if($request->get("id")==0){
            $store = new Popular_package();
            // $msg = "Popular Package Add Successfully";
            $msg = __('message.Popular Package Add Successfully');
        }else{
            $store = Popular_package::find($request->get("id"));
            // $msg = "Popular Package Add Successfully";
            $msg = __('message.Popular Package Add Successfully');
        }
        $store->name = $request->get("name");
        $store->type = $request->get("type");
        $store->type_id = $request->get("type_id");
        $store->save();
        Session::flash('message',$msg); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('popular-package');
    }


}
